//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			:
//******************************************

//******************************************
//Stack Pointer	=	0x23f (If use mq6822_32PinPackage_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 
#include "ADC.h"

//-- header guards --//
#ifndef	uchar
#define uchar unsigned char
#endif
#ifndef	uint
#define uint  unsigned int
#endif
#ifndef	ulong
#define ulong unsigned long
#endif



//-- function definition --//
void delay_times(uchar tBase, uint x);
void look_data(uchar data);


const uchar t_1ms   = 0;
const uchar t_100us = 1;
const uchar t_6u    = 2;	//HIRC: 8MHz, CGCR/4
const uchar t_3u    = 3;	//HIRC:16MHz, CGCR/4


uint  ADC_Code_READ;
ulong ADC_VOLTAGE;
uchar data2Port[2];

uint  vref_l, vref_h;
ulong iReal_Vref2V, adc_value, adc_GND;



void main()
{
	uchar iloop;

	WDCDR.byte = 0x4e;			// clear wdt


//-----------------------------------
//	perform this procedure once to get the actual value of internal Vref 2V
//	MQ6822:readout value is the actual value of internal Vref 2V multiplied by 1024 and its unit is mV
	iReal_Vref2V = GetVref();
//	do 16 conversion times
//	for( iloop=0; iloop<=(16/ad_test_times); iloop++ )
//		ADC_detect(Vref2, AIN_GND, Conv256CLK, ADC_Single);
//-----------------------------------
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt


		
//>>>>>>AD conversion times: ADC_ConvCode(faster) < ADC_ConvVolt,(MQ6822auto calibration)
//......................................................................................................
//------ADC_ConvVolt(,,,):AD conversion result (unit: mV)
//		ADC_VOLTAGE   = ADC_ConvVolt(Vref2, AIN7, Conv128CLK, ADC_Single);
//......................................................................................................
//------ADC_ConvCode(,,,):AD conversion result code
		ADC_Code_READ = ADC_ConvCode(Vref2, AIN7, Conv256CLK, ADC_Single);
		//.........................|......|.....|...........| ADC_Single, ADC_Repeat
		//.........................|......|.....| Conv32CLK, Conv64CLK, Conv128CLK, Conv256CLK, Conv512CLK, Conv1024CLK
		//.........................|......|.....| (*conversion times must be between 12.8 us to 128 us)
		//.........................|......|.....| fcgck=16M... Conv256CLK(16us) ~ Conv1024CLK( 64us)
		//.........................|......|.....| fcgck= 8M... Conv128CLK(16us) ~ Conv1024CLK(128us)
		//.........................|......|.....| fcgck= 4M... Conv64CLK (16us) ~ Conv512CLK (128us)
		//.........................|......|.....| fcgck= 2M... Conv32CLK (16us) ~ Conv256CLK (128us)
		//.........................|......| AIN0~AIN8, VDD4_1, AIN_GND
		//.........................| Vref2, Vref3, Vref4, VDDVref, EXTVref
		// the following list is AD conversion time reference value, FCGCK=16MHz,Conv256CLK(16us),Vref=2V
		// ad_test_times--Single(code)--Single(voltage)--Repeat(code)--Repeat(voltage)
		//       1      --  121us     --  156us        --  111us     --  146us
		//       2      --  222us     --  257us        --  150us     --  185us
		//       4      --  380us     --  415us        --  220us     --  255us
		//       8      --  700us     --  735us        --  349us     --  384us
		//      16      -- 1300us     -- 1335us        --  600us     --  635us




//		ADC_VOLTAGE  = ((ulong)ADC_Code_READ * 2000) / 1024;	// only for setting ADC reference voltage to internal 2V

		__ASM("NOP");


	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
}




//*********************************************************************
// name			: delay_times(uchar tBase, uint x)
// brief		: time delay function
// note			: ==> t_1ms   = 0;
// 			: ==> t_100us = 1;
// 			: ==> t_6u    = 2;	//HIRC: 8MHz, CGCR/4
// 			: ==> t_3u    = 3;	//HIRC:16MHz, CGCR/4
// 			: ...
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
	uint  i, cgcrT;
//	uchar cgcrF[4]={ 2, 4,  8, 1 };		// HIRC =>  8MHz
	uchar cgcrF[4]={ 4, 8, 16, 2 };		// HIRC => 16MHz

	cgcrT = cgcrF[CGCR.byte];			// 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
	switch(tBase){
		case 0:		// t_1ms
			cgcrT *= 110;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 1:		// t_100us
			cgcrT *= 11;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 2:		// t_6u				// HIRC: 8MHz, CGCR/4
			for(; x>0; x--){}
			break;
		case 3:		// t_3u				// HIRC:16MHz, CGCR/4
			for(; x>0; x--){}
			break;
	}
	WDCDR.byte=0x4e; 			// clear wdt
}



